package com.pay.util;

import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

public class Sign {

    public static String sha256(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = messageDigest.digest(str.getBytes("UTF-8"));
            //将byte转为16进制
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    sb.append("0");
                }
                sb.append(hex);
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (!Character.isWhitespace(cs.charAt(i))) {
                    return false;
                }
            }
            return true;
        } else {
            return true;
        }
    }

    public static void main(String[] args) {
        String secretKey = "2f90069bbbbfede0";
        TreeMap<String, Object> map = new TreeMap<>();
        map.put("amount", "1.00");
        map.put("route", "1");
        map.put("merchantId", "202203170000");
        map.put("notifyUrl", "http://www.test.com");
        map.put("merchantOrderId", "1515238243061202944");
        map.put("userId", "123123");
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!isBlank(String.valueOf(entry.getValue()))) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        sb.append("secretKey").append("=").append(secretKey);
        System.out.println("拼接串：" + sb);
        System.out.println("签名结果：" + sha256(sb.toString()));
    }
}
